package io.dyte.core.platform

import android.app.Activity
import io.dyte.core.controllers.IControllerContainer
import io.dyte.core.featureflag.DyteFeatureFlags
import io.dyte.core.models.VideoScaleType
import io.dyte.core.utils.DeviceId
import java.util.Locale

/**
 * Dyte android platform provider
 *
 * creates and maintains platform specific code required by core sdk
 *
 * @constructor Create empty Dyte android platform provider
 */
internal class DyteAndroidPlatformProvider
internal constructor(private val activity: Activity, override val videoScaleType: VideoScaleType) :
  IDytePlatformUtilsProvider {
  private lateinit var _controllerContainer: IControllerContainer

  private lateinit var platformUtils: DyteAndroidPlatform
  private lateinit var mediaUtils: DyteAndroidMedia
  private lateinit var videoUtils: DyteAndroidVideoUtils
  private lateinit var platformPermissionsUtils: DyteAndroidPlatformPermissions

  override fun init(controllerContainer: IControllerContainer) {
    this._controllerContainer = controllerContainer
    val forceSoftwareEncoder =
      controllerContainer.featureFlagService
        .getConfigValue(DyteFeatureFlags.SOFTWARE_ENCODER_OVERRIDE)
        .split(", ")
        .map(String::lowercase)
        .contains(DeviceId.getModelName().lowercase(Locale.US))
    val forceSoftwareDecoder =
      controllerContainer.featureFlagService
        .getConfigValue(DyteFeatureFlags.SOFTWARE_DECODER_OVERRIDE)
        .split(", ")
        .map(String::lowercase)
        .contains(DeviceId.getModelName().lowercase(Locale.US))
    mediaUtils = DyteAndroidMedia(this, forceSoftwareEncoder, forceSoftwareDecoder)
    videoUtils = DyteAndroidVideoUtils(this)
    platformUtils = DyteAndroidPlatform(activity)
    platformPermissionsUtils = DyteAndroidPlatformPermissions(activity)
  }

  override fun getPlatformUtils(): IDytePlatformUtils {
    return platformUtils
  }

  override fun getMediaUtils(): IDyteMediaUtils {
    return mediaUtils
  }

  override fun getControllerContainer(): IControllerContainer {
    return _controllerContainer
  }

  override fun createWebView(): IDyteWebView {
    return DyteAndroidWebView(this)
  }

  override fun getVideoUtils(): IDyteVideoUtils {
    return videoUtils
  }

  override fun getPermissionUtils(): IDytePlatformPermissionUtils {
    return platformPermissionsUtils
  }
}
