package io.dyte.core

import android.app.Activity
import io.dyte.core.models.VideoScaleType
import io.dyte.core.platform.DyteAndroidPlatformProvider

object DyteMeetingBuilder {
  private var videoScaleType: VideoScaleType = VideoScaleType.SCALE_ASPECT_FIT

  fun setVideoScaleType(videoScaleType: VideoScaleType): DyteMeetingBuilder {
    this.videoScaleType = videoScaleType
    return this
  }

  fun build(activity: Activity): DyteMobileClient {
    val dyteAndroidPlatformProvider = DyteAndroidPlatformProvider(activity, videoScaleType)
    return DyteMobileClient(dyteAndroidPlatformProvider)
  }
}
