package io.dyte.core.observability

import kotlinx.atomicfu.locks.reentrantLock
import kotlinx.atomicfu.locks.withLock
import kotlinx.datetime.Clock

// TODO : make this a static class
internal class DyteTracer : IDyteTracer {
  override val traces: List<DyteTrace>
    get() = _traces

  private val _traces = arrayListOf<DyteTrace>()

  private val lock = reentrantLock()

  private val currentTime: Long
    get() = Clock.System.now().toEpochMilliseconds()

  override fun startTrace(id: String) {
    lock.withLock {
      if (_traces.find { it.id == id } == null) {
        _traces.add(DyteTrace(id, currentTime))
      }
    }
  }

  override fun endTrace(id: String) {
    lock.withLock {
      val trace = _traces.find { it.id == id }
      if (trace != null) {
        trace.endedAt = currentTime
        val timeTaken = trace.endedAt - trace.startedAt
        DyteLogger.debug(
          "Tracer::${trace.id} took $timeTaken",
          mapOf("traceId" to trace.id, "traceTimeTaken" to timeTaken.toString()),
        )
        _traces.removeAll { it.id == id }
      }
    }
  }
}

// TODO : add a tags here.
internal data class DyteTrace(
  val id: String,
  val startedAt: Long,
  var endedAt: Long = -1,
  var isProcessed: Boolean = false,
)

internal interface IDyteTracer {
  val traces: List<DyteTrace>

  fun startTrace(id: String)

  fun endTrace(id: String)
}
