package io.dyte.core.feat

import io.dyte.core.feat.DyteMessageType.FILE
import io.dyte.core.feat.DyteMessageType.IMAGE
import io.dyte.core.feat.DyteMessageType.TEXT

open class DyteChatMessage(
  val userId: String,
  val displayName: String,
  val read: Boolean,
  val pluginId: String?,
  val type: DyteMessageType,
  val time: String,
  val channelId: String?,
  val targetUserIds: List<String>?,
)

class DyteTextMessage(
  userId: String,
  displayName: String,
  read: Boolean,
  pluginId: String?,
  val message: String,
  time: String,
  channelId: String? = null,
  targetUserIds: List<String>?,
) : DyteChatMessage(userId, displayName, read, pluginId, TEXT, time, channelId, targetUserIds)

class DyteImageMessage(
  userId: String,
  displayName: String,
  read: Boolean,
  pluginId: String?,
  val link: String,
  time: String,
  channelId: String? = null,
  targetUserIds: List<String>?,
) : DyteChatMessage(userId, displayName, read, pluginId, IMAGE, time, channelId, targetUserIds)

class DyteFileMessage(
  userId: String,
  displayName: String,
  read: Boolean,
  pluginId: String?,
  val name: String,
  time: String,
  val link: String,
  val size: Long,
  channelId: String? = null,
  targetUserIds: List<String>?,
) : DyteChatMessage(userId, displayName, read, pluginId, FILE, time, channelId, targetUserIds)

fun encodeDyteChatMessage(message: DyteChatMessage): Map<String, Any?> {
  val chatMessageMap = HashMap<String, Any?>()
  chatMessageMap["displayName"] = message.displayName
  chatMessageMap["type"] = message.type.name
  chatMessageMap["read"] = message.read
  chatMessageMap["user"] = message.userId
  chatMessageMap["pluginId"] = message.pluginId
  chatMessageMap["time"] = message.time
  chatMessageMap["channelId"] = message.channelId
  chatMessageMap["targetUserIds"] = message.targetUserIds
  when (message) {
    is DyteFileMessage -> {
      chatMessageMap["name"] = message.name
      chatMessageMap["link"] = message.link
      chatMessageMap["size"] = message.size
    }
    is DyteTextMessage -> {
      chatMessageMap["message"] = message.message
    }
    is DyteImageMessage -> {
      chatMessageMap["link"] = message.link
    }
  }
  return chatMessageMap
}

enum class DyteMessageType {
  TEXT,
  IMAGE,
  FILE
}
