package io.dyte.core.media

import android.app.Service
import android.content.Context
import android.content.Intent
import io.dyte.core.notification.NotificationUtils

internal class ScreenCaptureService : Service() {
  @Suppress("DEPRECATION")
  override fun onStartCommand(intent: Intent?, flags: Int, startId: Int): Int {
    val notification = NotificationUtils.getNotification(this)
    startForeground(notification.first, notification.second)

    val screenCaptureIntent: Intent? = intent?.getParcelableExtra("DATA")
    if (screenCaptureIntent != null) {
      screenShareCallback?.invoke(screenCaptureIntent)
    }

    return START_NOT_STICKY
  }

  override fun onDestroy() {
    super.onDestroy()
    screenShareCallback = null
  }

  override fun onBind(intent: Intent?) = null

  companion object {
    var screenShareCallback: ((Intent) -> Unit)? = null

    fun getIntent(context: Context, resultCode: Int, data: Intent): Intent {
      return Intent(context, ScreenCaptureService::class.java).apply {
        putExtra("ACTION", "START")
        putExtra("RESULT_CODE", resultCode)
        putExtra("DATA", data)
      }
    }
  }
}
