package io.dyte.core.socket.events.payloadmodel.outbound

import io.dyte.core.socket.events.OutboundMeetingEventType
import io.dyte.core.socket.events.payloadmodel.BasePayloadModel
import io.dyte.core.socket.events.payloadmodel.inbound.WebSocketMeetingPeerUser
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

/** response for [OutboundMeetingEventType.GET_ROOM_STATE] */
@Serializable
internal data class WebSocketRoomStateModel(val roomState: RoomState = RoomState()) :
  BasePayloadModel()

@Serializable
internal data class RoomState(
  val displayTitle: String = "",
  val peers: List<WebSocketMeetingPeerUser> = emptyList(),
  val lockedMode: Boolean = false,
  val roomUUID: String = "",
  val config: RoomStateConfig = RoomStateConfig(),
  val plugins: List<RoomStatePlugin> = emptyList(),
  val roomName: String = "",
  val currentPeerId: String? = null,
)

@Serializable
internal data class RoomStateConfig(
  val joinRestrictions: List<String> = emptyList(),
  val access: RoomStateAccess = RoomStateAccess(),
)

@Serializable
internal data class RoomStateAccess(
  val mic: String = "NOT_ALLOWED",
  val webcam: String = "NOT_ALLOWED",
  val screenShare: String = "NOT_ALLOWED",
  val plugins: String = "NOT_ALLOWED",
)

@Serializable
internal data class RoomStatePlugin(
  val id: String,
  val staggered: Boolean,
  val enabledBy: String? = null,
  val stores: List<String>,
  @SerialName("ACLAccessRemovedUsers") val aclAccessRemovedUsers: List<String>,
  @SerialName("ACLAccessGrantedUsers") val aclAccessGrantedUsers: List<String>,
  @SerialName("ACLType") val aclType: String,
)
