package io.dyte.core.feat

/**
 * Dyte poll message which contains the poll details
 *
 * @property id Poll id
 * @property question Poll question
 * @property anonymous If the poll is anonymous
 * @property hideVotes If the votes are hidden
 * @property createdBy Created by user id
 * @property options List of poll options of type [DytePollOption]
 * @property voted List of unique user ids who voted
 */
data class DytePollMessage(
  val id: String,
  val question: String,
  val anonymous: Boolean,
  val hideVotes: Boolean,
  val createdBy: String,
  val options: List<DytePollOption>,
  val voted: List<String>,
) {
  fun toMap(): Map<String, Any?> {
    val map = HashMap<String, Any?>()
    map["id"] = id
    map["question"] = question
    map["anonymous"] = anonymous
    map["hideVotes"] = hideVotes
    map["createdBy"] = createdBy
    map["options"] = options.map { it.toMap() }
    map["voted"] = voted
    return map
  }
}

data class DytePollOption(val text: String, val votes: List<DytePollVote>, val count: Int) {
  fun toMap(): Map<String, Any?> {
    val map = HashMap<String, Any?>()
    map["text"] = text
    map["votes"] = votes.map { it.toMap() }
    map["count"] = count
    return map
  }

  companion object {
    @Suppress("UNCHECKED_CAST")
    fun fromMap(pollOption: Map<String, Any>): DytePollOption {
      val text = pollOption["text"] as String
      val votes = pollOption["votes"] as List<Map<String, Any>>
      val pollVotes: List<DytePollVote> = votes.map { DytePollVote.fromMap(it) }
      val count = pollOption["count"] as Int
      return DytePollOption(text, pollVotes, count)
    }
  }
}

data class DytePollVote(val id: String, val name: String) {
  fun toMap(): Map<String, Any?> {
    val map = HashMap<String, Any?>()
    map["id"] = id
    map["name"] = name
    return map
  }

  companion object {
    fun fromMap(vote: Map<String, Any>): DytePollVote {
      val id = vote["id"] as String
      val name = vote["name"] as String
      return DytePollVote(id, name)
    }
  }
}
