package io.dyte.core.controllers

import io.dyte.core.network.ApiClient
import io.dyte.core.observability.DyteLogger
import io.dyte.core.socket.socketservice.SocketServiceEventListener
import io.dyte.core.socket.socketservice.SocketServiceUtils
import io.dyte.core.socket.socketservice.SockratesSocketService
import kotlinx.coroutines.CoroutineScope
import socket.recording.RecordingEvent

internal class RecordingSocketServiceController(
  apiClient: ApiClient,
  canRecord: Boolean,
  private val socket: SockratesSocketService,
  scope: CoroutineScope,
) : RecordingController(apiClient, canRecord, scope) {

  override fun setupEvents() {
    DyteLogger.info("DyteRecording::using socket-service-recording::")
    socket.subscribe(SocketServiceUtils.RoomEvent.RECORDING_STARTED.id, onRecordingStartedBroadcast)
    socket.subscribe(SocketServiceUtils.RoomEvent.RECORDING_STOPPED.id, onRecordingStoppedBroadcast)
    socket.subscribe(SocketServiceUtils.RoomEvent.RECORDING_PAUSED.id, onRecordingPausedBroadcast)
  }

  private val onRecordingStartedBroadcast =
    object : SocketServiceEventListener {
      override fun onEvent(event: Int, eventId: String?, payload: ByteArray?) {
        try {
          if (payload != null) {
            RecordingEvent.ADAPTER.decode(payload)
          }
          onRecordingPeerJoined()
        } catch (e: Error) {
          DyteLogger.error("RecordingController: Error in recording started broadcast $e")
        }
      }
    }

  private val onRecordingStoppedBroadcast =
    object : SocketServiceEventListener {
      override fun onEvent(event: Int, eventId: String?, payload: ByteArray?) {
        try {
          if (payload != null) {
            RecordingEvent.ADAPTER.decode(payload)
          }
          onRecordingPeerLeft()
        } catch (e: Error) {
          DyteLogger.error("RecordingController: Error in recording stopped broadcast $e")
        }
      }
    }

  private val onRecordingPausedBroadcast =
    object : SocketServiceEventListener {
      override fun onEvent(event: Int, eventId: String?, payload: ByteArray?) {
        try {
          if (payload != null) {
            RecordingEvent.ADAPTER.decode(payload)
          }
          onRecordingPaused()
        } catch (e: Error) {
          DyteLogger.error("RecordingController: Error in recording paused broadcast $e")
        }
      }
    }
}
