package io.dyte.core

import android.annotation.SuppressLint
import android.content.Context
import android.webkit.WebView
import io.dyte.core.feat.DytePlugin

@SuppressLint("ClickableViewAccessibility")
class DytePluginWebView(context: Context) : WebView(context) {
  private var plugin: DytePlugin? = null

  override fun setOnTouchListener(l: OnTouchListener?) {
    if (plugin?.config?.accessControl == "FULL_ACCESS") {
      super.setOnTouchListener(l)
    } else {
      // not allowed
    }
  }

  fun setPlugin(dytePlugin: DytePlugin) {
    this.plugin = dytePlugin
    if (dytePlugin.config.accessControl == "VIEW_ONLY") {
      super.setOnTouchListener { _, _ -> true }
    }
  }
}
