package io.dyte.core.waitingroom.hive

import io.dyte.core.socket.socketservice.ISockratesSocketService
import io.dyte.core.socket.socketservice.SocketServiceEventListener
import io.dyte.core.socket.socketservice.SocketServiceUtils
import io.dyte.core.waitingroom.WaitlistSubscription

internal class HiveWaitlistSubscription(private val socketService: ISockratesSocketService) :
  WaitlistSubscription() {
  private val waitlistStatusSocketServiceListener =
    object : SocketServiceEventListener {
      override fun onEvent(event: Int, eventId: String?, payload: ByteArray?) {
        handleWaitlistStatusSocketEvent(event, payload)
      }
    }

  override fun subscribe(subscriber: WaitlistSubscriber): Boolean {
    if (this.subscriber == null) {
      socketService.subscribe(
        SocketServiceUtils.RoomEvent.WAITING_ROOM_REQUEST_ACCEPTED.id,
        waitlistStatusSocketServiceListener,
      )
      socketService.subscribe(
        SocketServiceUtils.RoomEvent.WAITING_ROOM_REQUEST_REJECTED.id,
        waitlistStatusSocketServiceListener,
      )
    }
    return super.subscribe(subscriber)
  }

  override fun unsubscribe(subscriber: WaitlistSubscriber): Boolean {
    if (this.subscriber == subscriber) {
      socketService.unsubscribe(
        SocketServiceUtils.RoomEvent.WAITING_ROOM_REQUEST_ACCEPTED.id,
        waitlistStatusSocketServiceListener,
      )
      socketService.unsubscribe(
        SocketServiceUtils.RoomEvent.WAITING_ROOM_REQUEST_REJECTED.id,
        waitlistStatusSocketServiceListener,
      )
    }
    return super.unsubscribe(subscriber)
  }

  private fun handleWaitlistStatusSocketEvent(event: Int, payload: ByteArray?) {
    when (event) {
      SocketServiceUtils.RoomEvent.WAITING_ROOM_REQUEST_ACCEPTED.id -> {
        subscriber?.onWaitingRequestAccepted()
      }
      SocketServiceUtils.RoomEvent.WAITING_ROOM_REQUEST_REJECTED.id -> {
        subscriber?.onWaitingRequestRejected()
      }
      else -> {}
    }
  }
}
