package io.dyte.core.listeners

import io.dyte.core.feat.DytePlugin

/**
 * Dyte Plugin events listener
 *
 * You can subscribe to all plugin events by implementing this interface. To subscribe pass
 * implementation to [io.dyte.core.DyteMobileClient.addPluginEventsListener]
 */
interface DytePluginEventsListener : ExternalEventListener {
  /**
   * On plugin activated Triggered when a Plugin is activated for ongoing meeting. Should be used to
   * pass a webView to show Plugin.
   *
   * @param plugin Activated DytePlugin object
   */
  fun onPluginActivated(plugin: DytePlugin) {}

  /**
   * On plugin deactivated Triggered when a Plugin is deactivated for ongoing meeting. Should be
   * used to hide/remove the Plugin WebView from UI.
   *
   * @param plugin Deactivated DytePlugin object
   */
  fun onPluginDeactivated(plugin: DytePlugin) {}

  /**
   * On plugin message Triggered when a Plugin sends a custom event to client.
   *
   * @param plugin sender [DytePlugin]
   * @param eventName Name of the event
   * @param data Optional data sent by the Plugin. It can assume any Primitive, String, List & Map
   *   type.
   */
  fun onPluginMessage(plugin: DytePlugin, eventName: String, data: Any?) {}

  /**
   * On plugin file request Triggered when the user chooses to upload a file to Plugin. Should be
   * used to launch file chooser UI and select a file. The path of the selected file should be
   * passed to the Plugin object received in the [onPluginFileRequest] callback.
   * plugin.uploadFile(filePath)
   *
   * @param plugin DytePlugin which is requesting file
   */
  fun onPluginFileRequest(plugin: DytePlugin) {}
}
