package io.dyte.core.feat

import io.dyte.core.controllers.MeetingConfig
import io.dyte.core.controllers.MetaController
import io.dyte.core.models.ActiveTabType
import io.dyte.core.models.DyteMeetingState
import io.dyte.core.models.DyteMeetingType
import io.dyte.core.spotlight.ActiveTab

class DyteMeta internal constructor(private val metaController: MetaController) {

  @Deprecated("Use meetingName")
  val roomName: String
    get() = metaController.getRoomName()

  val meetingId: String
    get() = metaController.getRoomName()

  val meetingTitle: String
    get() = metaController.getMeetingTitle()

  val meetingStartedTimestamp: String
    get() = metaController.getMeetingStatedTimestamp()

  val meetingType: DyteMeetingType
    get() = metaController.getMeetingType()

  val authToken: String
    get() = metaController.getAuthToken()

  val meetingConfig: MeetingConfig
    get() = metaController.getMeetingConfig()

  val meetingState: DyteMeetingState
    get() = metaController.meetingState

  val selfActiveTab: ActiveTab?
    get() = metaController.selfActiveTab

  fun toMap(): Map<String, Any?> {
    val map = HashMap<String, Any?>()
    map["roomName"] = roomName
    map["meetingTitle"] = meetingTitle
    map["meetingStartedTimestamp"] = meetingStartedTimestamp
    map["meetingType"] = meetingType.name
    return map
  }

  /* id is the identifier for recognising unique plugin/screen share*/
  fun syncTab(id: String, tabType: ActiveTabType) {
    metaController.syncTab(id, tabType)
  }
}
