@file:Suppress("EnumEntryName")

package io.dyte.core

enum class SocketErrorCode(val code: Int) {
  Get_Socket_Response_Timeout(12),
  Get_Socket_Response_Is_Null(13)
}

enum class HostControlErrorCodes(val code: Int, val description: String) {
  Unpin_Peer(12, description = "Failed to unpin peer"),
  Pin_Peer(13, description = "Failed to pin peer"),
  Mute_Video(14, description = "Failed to mute video"),
  Mute_Audio(15, description = "Failed to mute audio"),
  Mute_All_Video(16, description = "Failed to mute all video"),
  Mute_All_Audio(17, description = "Failed to mute all audio"),
  Kick_All(18, description = "Failed to kill all"),
  Kick_Peer(19, description = "Failed to kick peer")
}

enum class PresetEditorErrorCodes(val code: Int, val description: String) {
  Record_Permission_Not_Given(12, description = "Record permission is not given on preset editor."),
  Recording_Start_Exception(13, description = "Failed to start recording"),
  Recording_Pause_Exception(14, description = "Failed to pause recording"),
  Recording_Resume_Exception(15, description = "Failed to resume recording"),
  Recording_Stop_Exception(16, description = "Failed to stop recording"),
  No_Active_Recording_Found(17, description = "There is no active recording is in progress")
}

enum class MeetingErrorCodes(val code: Int, val description: String) {
  Invalid_Auth_Token(1000, description = "Invalid auth token"),
  Meeting_Init_Failed(1002, description = "Failed to initialize meeting"),
  Invalid_Base_Url(1003, description = "Invalid base url"),
  Join_Room_Failed(1005, description = "Failed to join room"),
  Unknown_Error(4000, description = "Something went wrong"),
}

enum class SelfErrorCodes(val code: Int, val description: String) {
  Audio_Prod_Not_Supported(2000, description = "Current meeting does not support audio production"),
  Video_Prod_Not_Supported(2001, description = "Current meeting does not support video production"),
  Audio_Not_Allowed(2002, description = "User not allowed to produce audio"),
  Video_Not_Allowed(2003, description = "User not allowed to produce video"),
  Audio_Not_Permitted(2004, description = "User does not have platform permission produce audio"),
  Video_Not_Permitted(2005, description = "User does not have platform permission produce video")
}

enum class ChatErrorCodes(val code: Int, val description: String) {
  Chat_Not_Supported(5000, description = "Permission denied"),
  Chat_Files_Not_Supported(5001, description = "Permission denied")
}

class DyteError(val code: Int, val message: String) {
  internal constructor(
    socketErrorCode: SocketErrorCode,
    message: String,
  ) : this(socketErrorCode.code, message)

  internal constructor(
    errorCode: PresetEditorErrorCodes
  ) : this(errorCode.code, errorCode.description)

  internal constructor(
    errorCode: PresetEditorErrorCodes,
    message: String,
  ) : this(errorCode.code, message)

  internal constructor(
    errorCode: HostControlErrorCodes
  ) : this(errorCode.code, errorCode.description)

  internal constructor(
    errorCode: HostControlErrorCodes,
    message: String,
  ) : this(errorCode.code, message)

  internal constructor(errorCode: MeetingErrorCodes) : this(errorCode.code, errorCode.description)

  internal constructor(
    errorCode: SelfErrorCodes,
    message: String? = null,
  ) : this(errorCode.code, message ?: errorCode.description)

  internal constructor(
    errorCode: ChatErrorCodes,
    message: String? = null,
  ) : this(errorCode.code, message ?: errorCode.description)
}

sealed class Result<out SuccessType, out FailureType> {
  data class Success<out R>(val value: R) : Result<R, Nothing>()

  data class Failure<out R>(val value: R) : Result<Nothing, R>()
}
