package io.dyte.core.media

import android.content.Intent
import android.media.projection.MediaProjection
import io.dyte.webrtc.DEFAULT_FRAME_RATE
import io.dyte.webrtc.DEFAULT_VIDEO_HEIGHT
import io.dyte.webrtc.DEFAULT_VIDEO_WIDTH
import io.dyte.webrtc.VideoCaptureController
import io.webrtc.ScreenCapturerAndroid
import io.webrtc.Size
import io.webrtc.VideoCapturer
import io.webrtc.VideoSource

internal class ScreenVideoCaptureController(videoSource: VideoSource, private val intent: Intent) :
  VideoCaptureController(videoSource) {

  override fun createVideoCapturer(): VideoCapturer {
    return ScreenCapturerAndroid(intent, object : MediaProjection.Callback() {})
  }

  override fun selectVideoSize(): Size {
    return Size(DEFAULT_VIDEO_WIDTH, DEFAULT_VIDEO_HEIGHT)
  }

  override fun selectFps(): Int {
    return DEFAULT_FRAME_RATE
  }
}
