package io.dyte.core.utils

import java.util.concurrent.CopyOnWriteArrayList
import kotlin.reflect.KProperty1
import kotlinx.atomicfu.locks.reentrantLock
import kotlinx.atomicfu.locks.withLock

internal actual class ReadHeavyMutableList<T> {
  val lock = reentrantLock()
  var internalList = CopyOnWriteArrayList<T>()

  actual val size: Int
    get() = internalList.size

  actual fun contains(element: T): Boolean = internalList.contains(element)

  actual fun get(index: Int): T = internalList[index]

  actual fun indexOf(element: T): Int = internalList.indexOf(element)

  actual fun isEmpty(): Boolean = internalList.isEmpty()

  actual fun lastIndexOf(element: T): Int = internalList.lastIndexOf(element)

  actual fun add(element: T): Boolean =
    lock.withLock {
      return internalList.add(element)
    }

  actual fun addAll(index: Int, elements: Collection<T>): Boolean =
    lock.withLock {
      return internalList.addAll(index, elements)
    }

  actual fun addAll(elements: Collection<T>): Boolean =
    lock.withLock {
      return internalList.addAll(elements)
    }

  actual fun clear(): Unit = lock.withLock { internalList.clear() }

  actual fun remove(element: T): Boolean = lock.withLock { internalList.remove(element) }

  actual fun removeAll(elements: Collection<T>): Boolean =
    lock.withLock {
      return internalList.removeAll(elements)
    }

  actual fun removeAll(function: (T) -> Boolean): Boolean =
    lock.withLock {
      return internalList.removeAll(function)
    }

  actual fun removeAt(index: Int): T =
    lock.withLock {
      return internalList.removeAt(index)
    }

  actual fun set(index: Int, element: T): T =
    lock.withLock {
      return internalList.set(index, element)
    }

  actual fun find(function: (T) -> Boolean): T? = internalList.find(function)

  actual fun subList(fromIndex: Int, toIndex: Int): MutableList<T> =
    internalList.subList(fromIndex, toIndex).toMutableList()

  actual fun toSafeList(): List<T> = internalList

  actual fun add(index: Int, element: T) {
    lock.withLock { internalList.add(index, element) }
  }

  actual fun distinctBy(property: KProperty1<T, String>): List<T> {
    return internalList.distinctBy(property)
  }
}
