package io.dyte.core.media

import android.app.Activity
import android.content.Context
import android.content.Intent
import android.media.projection.MediaProjectionManager
import android.os.Build
import android.os.Bundle
import androidx.annotation.RequiresApi
import io.dyte.core.controllers.SelfController

internal class ScreenCaptureActivity : Activity() {
  companion object {
    internal var selfController: SelfController? = null
  }

  private val mMediaProjectionManager by lazy {
    getSystemService(Context.MEDIA_PROJECTION_SERVICE) as MediaProjectionManager
  }

  override fun onCreate(savedInstanceState: Bundle?) {
    super.onCreate(savedInstanceState)
    startActivityForResult(mMediaProjectionManager.createScreenCaptureIntent(), 100)
  }

  @RequiresApi(Build.VERSION_CODES.O)
  override fun onActivityResult(requestCode: Int, resultCode: Int, data: Intent?) {
    when (requestCode) {
      100 ->
        if (resultCode == RESULT_OK) {
          startForegroundService(
            ScreenCaptureService.getIntent(this, RESULT_OK, requireNotNull(data))
          )
        } else {
          selfController?.emitEvent { it.onScreenShareStartFailed("cancelled by user") }
        }
      else -> super.onActivityResult(requestCode, resultCode, data)
    }
    finish()
  }
}
