package io.dyte.core.platform

import io.dyte.core.controllers.Permission

interface IDytePlatformPermissionUtils {
  fun isPermissionGranted(permission: Permission): Boolean

  fun arePermissionsGranted(permissions: List<Permission>): Boolean

  fun askPermissions(
    permissions: List<Permission>,
    onPermissionsGranted: () -> Unit,
    onPermissionsDenied: () -> Unit,
  ): Boolean

  fun askCameraPermissions(
    onPermissionsGranted: () -> Unit,
    onPermissionsDenied: () -> Unit,
  ): Boolean {
    // Returning false we are not handling this methods
    return false
  }

  fun askAudioPermissions(
    onPermissionsGranted: () -> Unit,
    onPermissionsDenied: () -> Unit,
  ): Boolean {
    // Returning false we are not handling this methods
    return false
  }

  /**
   * Determines whether Bluetooth permission should be requested.
   *
   * NOTE: Override this method only for the Android platform with API level >= 31. For other
   * platforms and Android API levels, it returns false.
   */
  fun shouldRequestBluetoothPermission(): Boolean {
    return false
  }
}
