package io.dyte.core.socket.events.payloadmodel.outbound

import io.dyte.core.socket.events.OutboundMeetingEventType
import io.dyte.core.socket.events.payloadmodel.BasePayloadModel
import io.dyte.core.socket.events.payloadmodel.inbound.WebSocketMeetingPeerUser
import io.dyte.core.socket.events.payloadmodel.inbound.WebSocketRequestToJoinType
import io.dyte.core.socket.events.payloadmodel.inbound.WebSocketStageStatus
import kotlinx.serialization.Serializable

/** response for [OutboundMeetingEventType.JOIN_ROOM] */
@Serializable
data class WebSocketJoinRoomModel(
  val waitlisted: Boolean = false,
  val peers: List<WebSocketMeetingPeerUser> = emptyList(),
  val waitlistedPeers: List<WebSocketWaitlistedPeer> = emptyList(),
  val requestToJoinPeersList: List<WebSocketJoinStageRequestedPeer> = emptyList(),
  val startedAt: String? = null,
  val pinnedPeerId: String? = null,
  val stageStatus: WebSocketStageStatus = WebSocketStageStatus.OFF_STAGE,
) : BasePayloadModel()

@Serializable data class WebSocketWaitlistedPeer(val id: String, val name: String? = null)

@Serializable
data class WebSocketJoinStageRequestedPeer(
  val id: String,
  val userId: String? = null,
  val requestToJoinType: WebSocketRequestToJoinType = WebSocketRequestToJoinType.REQUEST_TO_PRESENT,
  val name: String? = null,
)
