package io.dyte.core.socket.events.payloadmodel.inbound

import io.dyte.core.socket.events.InboundMeetingEventType
import io.dyte.core.socket.events.payloadmodel.BasePayloadModel
import io.dyte.core.socket.events.payloadmodel.outbound.Codec
import io.dyte.core.socket.events.payloadmodel.outbound.HeaderExtension
import kotlinx.serialization.Serializable

/** response for event [InboundMeetingEventType.WEB_SOCKET_NEW_CONSUMER] */
@Serializable
data class WebSocketConsumerModel(
  val peerId: String,
  val producerId: String,
  val id: String,
  val kind: String, // 'audio' or 'video'
  val rtpParameters: ConsumerRtpParameters = ConsumerRtpParameters(),
  val type: String, // 'simple' | 'simulcast' | 'svc' | 'pipe'
  val appData: ConsumerAppData? = null,
  val remotelyPaused: Boolean,
  val producerPaused: Boolean,
) : BasePayloadModel()

@Serializable
data class ConsumerRtpParameters(
  val codecs: List<Codec>? = null,
  val headerExtensions: List<HeaderExtension>? = null,
  val encodings: List<Encodings>? = null,
  val rtcp: Rtcp? = null,
  val mid: String? = null,
)

@Serializable data class ConsumerAppData(var screenShare: Boolean = false, val peerId: String)

@Serializable
data class Encodings(
  val ssrc: Int? = null,
  val rtx: Rtx? = null,
  val scalabilityMode: String? = null,
)

@Serializable class Rtx(val ssrc: Int? = null)

@Serializable
data class Rtcp(
  val cname: String? = null,
  val reducedSize: Boolean? = null,
  val mux: Boolean? = null,
)
