package io.dyte.core.network.models

import kotlinx.serialization.ExperimentalSerializationApi
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable
import kotlinx.serialization.json.JsonElement
import kotlinx.serialization.json.JsonNames

@Serializable
data class UserPresetRequestModel(
  @SerialName("authToken") val authToken: String? = null,
  @SerialName("clientType") val clientType: String? = null,
  @SerialName("roomName") val roomName: String? = null,
  @SerialName("version") val version: String? = null,
)

@Serializable
data class UserPresetDataWrapper(
  @SerialName("success") val success: Boolean? = null,
  @SerialName("message") val message: String? = null,
  @SerialName("data") val data: UserPresetData? = null,
)

@Serializable data class UserPresetData(@SerialName("preset") val preset: UserPresetModel? = null)

@Serializable
data class UserPresetModel(
  @SerialName("permissions") val permissions: UserPresetPermissionsModel? = null,
  @SerialName("theme") val theme: UserPresetThemeModel? = null,
  @SerialName("version") val version: String? = null,
  @SerialName("preset_name") val presetName: String? = null,
  val ui: UserPresetUI? = null,
)

@Serializable
data class UserPresetPermissionsModel(
  @SerialName("view_type") val viewType: String? = null,
  @SerialName("accept_waiting_requests") val acceptWaitingRequests: Boolean? = null,
  @SerialName("request_produce") val requestProduce: Boolean? = null,
  @SerialName("can_allow_participant_screensharing")
  val canAllowParticipantScreensharing: Boolean? = null,
  @SerialName("can_allow_participant_audio") val canDisableParticipantAudio: Boolean? = null,
  @SerialName("can_allow_participant_video") val canDisableParticipantVideo: Boolean? = null,
  @SerialName("request_kick_participant") val requestKickParticipant: Boolean? = null,
  @SerialName("kick_participant") val kickParticipant: Boolean? = null,
  @SerialName("pin_participant") val pinParticipant: Boolean? = null,
  @SerialName("can_record") val canRecord: Boolean? = null,
  @SerialName("waiting_room_type") val waitingRoomType: WaitingRoomType,
  @SerialName("plugins") val plugins: UserPresetPluginPermissions? = null,
  @SerialName("polls") val polls: UserPresetPollsPermissions? = null,
  @SerialName("produce") val produce: UserPresetProducePermissions? = null,
  @SerialName("chat") val chat: UserPresetChatPermissionProps? = null,
  @SerialName("reactions") val reactions: Boolean? = null,
  @SerialName("hidden_participant") val hiddenParticipant: Boolean? = null,
  @SerialName("show_participant_list") val showParticipantList: Boolean? = null,
  @SerialName("can_change_participant_role") val canChangeParticipantRole: Boolean? = null,
  @SerialName("can_change_theme") val canChangeTheme: Boolean? = null,
  @SerialName("can_present") val canPresent: Boolean? = null,
  @SerialName("accept_present_requests") val acceptPresentRequests: Boolean? = null,
  @SerialName("can_edit_display_name") val canEditDisplayName: Boolean? = null,
  @SerialName("is_recorder") val isRecorder: Boolean? = null,
  @SerialName("can_spotlight") val canSpotLight: Boolean? = null,
)

@Serializable
data class UserPresetPluginPermissions(
  @SerialName("can_close") val canClose: Boolean? = null,
  @SerialName("can_start") val canStart: Boolean? = null,
  @SerialName("can_edit_acl") val canEditAcl: Boolean? = null,
  @SerialName("config") val config: UserPresetPluginConfig? = null,
)

@Serializable class UserPresetPluginConfig

@Serializable
data class UserPresetPollsPermissions(
  @SerialName("can_create") val canCreate: Boolean? = null,
  @SerialName("can_vote") val canVote: Boolean? = null,
  @SerialName("can_view") val canView: Boolean? = null,
)

@Serializable
data class UserPresetChatPermissionProps(
  @SerialName("public") val chatPublicProps: ChatPublicPermissions? = null,
  @SerialName("private") val chatPrivateProps: ChatPrivatePermissions? = null,
)

@Serializable
data class ChatPrivatePermissions(
  @SerialName("can_send") val canSend: Boolean? = null,
  @SerialName("can_receive") val canReceive: Boolean? = null,
  @SerialName("text") val text: Boolean? = null,
  @SerialName("files") val files: Boolean? = null,
)

@Serializable
data class ChatPublicPermissions(
  @SerialName("can_send") val canSend: Boolean? = null,
  @SerialName("text") val text: Boolean? = null,
  @SerialName("files") val files: Boolean? = null,
)

@Serializable
data class UserPresetProducePermissions(
  @SerialName("video") val video: UserPresetVideoPermissions? = null,
  @SerialName("audio") val audio: Boolean? = null,
  @SerialName("screenshare") val screenshare: UserPresetScreenSharePermissions? = null,
)

@Serializable
data class UserPresetScreenSharePermissions(
  @SerialName("allow") val allow: Boolean? = null,
  @SerialName("quality") val quality: String? = null,
  @SerialName("frame_rate") val frameRate: Int? = null,
)

@Serializable
data class UserPresetVideoPermissions(
  @SerialName("allow") val allow: Boolean? = null,
  @SerialName("quality") val quality: String? = null,
  @SerialName("frame_rate") val frameRate: Int? = null,
)

@Serializable
data class UserPresetThemeModel(
  // @SerialName("setup_screen")
  // var setupScreen: UserPresetSetupScreenTheme? = null,

  // @SerialName("alone_here")
  // var aloneHere: UserPresetAloneHereTheme? = null,

  // @SerialName("waiting_room")
  // var waitingRoom: UserPresetWaitingRoomTheme? = null,

  // @SerialName("control_bar")
  // var controlBar: UserPresetControlBarTheme? = null,

  // @SerialName("header")
  // var header: UserPresetHeaderTheme? = null,

  // @SerialName("pip_mode")
  // var pipMode: Boolean? = null,

  // @SerialName("auto_tune")
  // var autoTune: Boolean? = null,

  @SerialName("grid") var grid: UserPresetGridTheme? = null

  // @SerialName("colors")
  // var colors: UserPresetColorsTheme? = null
)

@Serializable
data class UserPresetAloneHereTheme(@SerialName("is_enabled") var isEnabled: Boolean? = null)

/*
Note(swapnil): Temporarily have changed the primary, secondary, background and textPrimary fields
type to JsonElement as String type was not getting parsed in staging environment and app was crashing.
Will fix this with RK before merging to staging.
 */
@Serializable
data class UserPresetColorsTheme(
  @SerialName("primary") var primary: JsonElement? = null,
  @SerialName("secondary") var secondary: JsonElement? = null,
  @SerialName("text") var text: String? = null,
  @SerialName("background") var background: JsonElement? = null,
  @SerialName("textPrimary") var textPrimary: JsonElement? = null,
  @SerialName("videoBackground") var videoBackground: String? = null,
)

@Serializable
data class UserPresetControlBarTheme(
  @SerialName("is_enabled") var isEnabled: Boolean? = null,
  @SerialName("elements") var elements: UserPresetControlBarThemeElements? = null,
)

@Serializable
data class UserPresetControlBarThemeElements(
  @SerialName("plugins") var plugins: Boolean? = null,
  @SerialName("screenshare") var screenshare: Boolean? = null,
  @SerialName("invite") var invite: Boolean? = null,
  @SerialName("participants") var participants: Boolean? = null,
  @SerialName("chat") var chat: Boolean? = null,
  @SerialName("reactions") var reactions: Boolean? = null,
  @SerialName("polls") var polls: Boolean? = null,
  @SerialName("fullscreen") var fullscreen: Boolean? = null,
  @SerialName("layout") var layout: Boolean? = null,
)

@Serializable
data class UserPresetHeaderThemeElements(
  @SerialName("logo") var logo: String? = null,
  @SerialName("timer") var timer: Boolean? = null,
  @SerialName("title") var title: Boolean? = null,
  @SerialName("participant_count") var participantCount: Boolean? = null,
  @SerialName("change_layout") var changeLayout: Boolean? = null,
)

@Serializable
data class UserPresetGridTheme(
  @SerialName("multi") var multi: UserPresetMultiTheme? = null,
  @SerialName("single") var single: UserPresetSingleTheme? = null,
  @SerialName("defaultView") var defaultView: String? = null,
)

@Serializable
data class UserPresetHeaderTheme(
  @SerialName("is_enabled") var isEnabled: Boolean? = null,
  @SerialName("elements") var elements: UserPresetHeaderThemeElements? = null,
)

@Serializable
data class UserPresetMultiTheme(
  @SerialName("maxVideoCount") var maxVideoCount: Int? = null,
  @SerialName("videoFit") var videoFit: String? = null,
)

// ignore
@Serializable
data class UserPresetSetupScreenTheme(@SerialName("is_enabled") var isEnabled: Boolean? = null)

@Serializable
data class UserPresetSingleTheme(
  @SerialName("maxVideoCount") var maxVideoCount: Int? = null,
  @SerialName("videoFit") var videoFit: String? = null,
)

@Serializable
data class UserPresetWaitingRoomTheme(
  @SerialName("is_enabled") var isEnabled: Boolean? = null,
  @SerialName("enable_preview") var enablePreview: Boolean? = null,
)

@Serializable
enum class WaitingRoomType {
  @SerialName("SKIP") SKIP,
  @SerialName("ON_ACCEPT") ON_ACCEPT,
  @SerialName("SKIP_ON_ACCEPT") SKIP_ON_ACCEPT,
  @OptIn(ExperimentalSerializationApi::class)
  @JsonNames("SKIP_ON_PRIVILEGED_USER_ENTRY", "ON_PRIVILEGED_USER_ENTRY")
  ON_PRIVILEGED_USER_ENTRY
}
