package io.dyte.core.network.models

import kotlinx.serialization.Serializable

@Serializable data class PluginFiles(val include: Array<String>, val exclude: Array<String>?)

@Serializable data class PluginView(var url: String, var suggestedPosition: String)

@Serializable
data class PluginConfigResponse(
  val name: String,
  val pluginId: String,
  val version: String,
  val description: String,
  val author: String?,
  val repository: String?,
  val tags: Array<String>,
  val picture: String,
  val url: String?,
  val files: PluginFiles,
  val views: Map<String, PluginView> = emptyMap(),
  val contentScript: String? = null,
)

@Serializable data class PluginAuthResponse(val data: PluginAuthDataResponse)

@Serializable data class PluginAuthDataResponse(val token: String)
