package io.dyte.core.models

data class DyteAudioDevice internal constructor(val id: String, val type: AudioDeviceType) {

  companion object default {
    @Suppress("UNCHECKED_CAST")
    fun fromMap(map: Map<String, Any>): DyteAudioDevice {
      val id = map.get("id") as String
      val typeMap = map.get("type") as Map<String, Any>
      val type = AudioDeviceType.fromMap(typeMap)
      return DyteAudioDevice(id, type)
    }
  }

  fun toMap(): Map<String, Any?> {
    val map = HashMap<String, Any?>()
    map["id"] = id
    map["type"] = type.toMap()
    return map
  }
}

enum class AudioDeviceType(val deviceType: String, val displayName: String) {
  WIRED("WIRED_HEADSET", "Headset"),
  SPEAKER("SPEAKER_PHONE", "Speaker"),
  BLUETOOTH("BLUETOOTH", "Bluetooth"),
  EAR_PIECE("EARPIECE", "Earpiece"),
  UNKNOWN("NONE", "Unknown");

  companion object default {
    @Suppress("UNCHECKED_CAST")
    fun fromMap(map: Map<String, Any>): AudioDeviceType {
      return when (map["deviceType"]) {
        "WIRED_HEADSET" -> WIRED
        "SPEAKER_PHONE" -> SPEAKER
        "BLUETOOTH" -> BLUETOOTH
        "EARPIECE" -> EAR_PIECE
        else -> UNKNOWN
      }
    }
  }

  fun toMap(): Map<String, Any?> {
    @Suppress("UNCHECKED_CAST") val map = HashMap<String, Any?>()
    map["deviceType"] = deviceType
    map["displayName"] = displayName
    return map
  }
}
