package io.dyte.core.media

import io.dyte.core.controllers.IControllerContainer
import io.dyte.core.network.models.IceServerData
import io.dyte.core.socket.events.payloadmodel.inbound.WebSocketConsumerClosedModel
import io.dyte.core.socket.events.payloadmodel.inbound.WebSocketConsumerModel
import io.dyte.core.socket.events.payloadmodel.outbound.RouterCapabilitiesModel
import io.dyte.core.socket.events.payloadmodel.outbound.WebRtcCreateTransportModel
import io.dyte.webrtc.VideoStreamTrack

internal interface IDyteMediaSoupUtils : IDyteSFUUtils {
  fun init(controllerContainer: IControllerContainer)

  suspend fun loadRouterRtpCapabilities(routerRtpCapabilities: RouterCapabilitiesModel)

  suspend fun createWebRtcTransportRecv(
    model: WebRtcCreateTransportModel,
    iceServers: List<IceServerData>,
  )

  suspend fun createWebRtcTransportProd(
    model: WebRtcCreateTransportModel,
    iceServers: List<IceServerData>,
  )

  suspend fun connectCameraTransport()

  suspend fun connectAudioTransport(id: String)

  fun handleNewConsumer(webSocketConsumerModel: WebSocketConsumerModel, onDone: () -> Unit)

  fun handleCloseConsumer(webSocketConsumerModel: WebSocketConsumerClosedModel)

  fun resumeConsumer(id: String)

  fun getSelfTrack(): Pair<Any?, VideoStreamTrack?>

  fun onCameraStreamKilled()

  suspend fun handleCloseProducer(id: String)
}
