package io.dyte.core.host

import io.dyte.core.DyteError
import io.dyte.core.Result

internal interface IHostController {
  suspend fun kickPeer(peerId: String): Result<Unit, DyteError>

  suspend fun kickAll(): Result<Unit, DyteError>

  suspend fun muteAllAudio(allowUnmute: Boolean? = null): Result<Unit, DyteError>

  suspend fun muteAllVideo(): Result<Unit, DyteError>

  suspend fun muteAudio(peerId: String): Result<Unit, DyteError>

  suspend fun muteVideo(peerId: String): Result<Unit, DyteError>

  suspend fun pinPeer(peerId: String): Result<Unit, DyteError>

  suspend fun unpinPeer(): Result<Unit, DyteError>
}
