package io.dyte.core.feat

import io.dyte.core.controllers.*
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.DelicateCoroutinesApi
import kotlinx.coroutines.ExperimentalCoroutinesApi
import kotlinx.coroutines.launch
import kotlinx.coroutines.newSingleThreadContext

class DyteLiveStream internal constructor(private val controller: IControllerContainer) {
  @OptIn(DelicateCoroutinesApi::class, ExperimentalCoroutinesApi::class)
  private val serialScope = CoroutineScope(newSingleThreadContext("DyteLiveStream"))

  val liveStreamUrl: String?
    get() = controller.liveStreamController.livestreamData.liveStreamUrl

  val state: LiveStreamState
    get() = controller.liveStreamController.livestreamData.state

  val roomName: String
    get() = controller.metaController.getMeetingTitle()

  fun start() {
    serialScope.launch { controller.liveStreamController.start() }
  }

  fun stop() {
    serialScope.launch { controller.liveStreamController.stop() }
  }
}
