package io.dyte.core.platform

data class PlatformFile(
  val name: String,
  val content: ByteArray,
  val size: Long, // Size in bytes
  val mimeType: String?,
) {
  override fun equals(other: Any?): Boolean {
    if (this === other) return true
    if (other == null || this::class != other::class) return false

    other as PlatformFile

    if (name != other.name) return false
    if (!content.contentEquals(other.content)) return false
    if (size != other.size) return false
    if (mimeType != other.mimeType) return false

    return true
  }

  override fun hashCode(): Int {
    var result = name.hashCode()
    result = 31 * result + content.contentHashCode()
    result = 31 * result + size.hashCode()
    result = 31 * result + (mimeType?.hashCode() ?: 0)
    return result
  }
}
