package io.dyte.core

import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.DelicateCoroutinesApi
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.ExperimentalCoroutinesApi
import kotlinx.coroutines.cancel
import kotlinx.coroutines.newSingleThreadContext

internal open class ControllerScopeProvider {
  @OptIn(DelicateCoroutinesApi::class, ExperimentalCoroutinesApi::class)
  val serialScope = CoroutineScope(newSingleThreadContext("DyteScope${hashCode()}"))
  val callBackScope = CoroutineScope(Dispatchers.Default)

  fun isRunningOnMainThread(): Boolean {
    return true
  }
  //    protected fun dispathCallBack(onMain: Boolean, callBack: ()->Unit) {
  //        if (onMain) {
  //            callBackScope.launch (Dispatchers.Main) {
  //                callBack()
  //            }
  //        }else {
  //            callBackScope.launch { callBack() }
  //        }
  //    }

  open fun dispose() {
    serialScope.coroutineContext.cancel()
  }
}
