package io.dyte.core.notification

import android.app.Notification
import android.app.NotificationChannel
import android.app.NotificationManager
import android.content.Context
import android.os.Build
import androidx.core.app.NotificationCompat
import io.dyte.core.R

internal object NotificationUtils {
  private const val NOTIFICATION_ID = 1337
  private const val NOTIFICATION_CHANNEL_ID = "screen_share"
  private const val NOTIFICATION_CHANNEL_NAME = "Dyte"

  fun getNotification(context: Context): Pair<Int, Notification> {
    createNotificationChannel(context)
    val notification: Notification = createNotification(context)
    val notificationManager =
      context.getSystemService(Context.NOTIFICATION_SERVICE) as NotificationManager
    notificationManager.notify(NOTIFICATION_ID, notification)
    return Pair(NOTIFICATION_ID, notification)
  }

  private fun createNotificationChannel(context: Context) {
    /**
     * Create the [NotificationChannel], but only on API 26+ because the [NotificationChannel] class
     * is new and not in the support library
     */
    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
      val channel =
        NotificationChannel(
            NOTIFICATION_CHANNEL_ID,
            NOTIFICATION_CHANNEL_NAME,
            NotificationManager.IMPORTANCE_LOW
          )
          .also { it.lockscreenVisibility = Notification.VISIBILITY_PRIVATE }

      val notificationManager =
        context.getSystemService(Context.NOTIFICATION_SERVICE) as NotificationManager
      notificationManager.createNotificationChannel(channel)
    }
  }

  private fun createNotification(context: Context): Notification {
    return NotificationCompat.Builder(context, NOTIFICATION_CHANNEL_ID)
      .apply {
        priority = NotificationCompat.PRIORITY_HIGH
        setCategory(NotificationCompat.CATEGORY_SERVICE)
        setOngoing(true)
        setSmallIcon(R.drawable.ic_baseline_videocam_24) // temporary icon
        setContentTitle("Screen Share")
        setContentText("Recording")
        setShowWhen(true)
      }
      .build()
  }
}
