package io.dyte.core.socket

import io.dyte.socketio.IO
import io.dyte.socketio.IOOptions
import io.dyte.socketio.src.engine.asString
import kotlin.coroutines.resume
import kotlin.coroutines.suspendCoroutine
import kotlinx.serialization.json.JsonElement

class Socket(
  endpoint: String,
  @Suppress("UNUSED_PARAMETER") // Might use it in the future?
  config: SocketOptions? = null,
) {

  val socketIo =
    IO.socket(
      endpoint,
      IOOptions().apply {
        reconnectionAttempts = 100
        reconnectionDelay = 500
      }
    )

  suspend fun emitAck(event: String, data: String): String? {
    return suspendCoroutine { cont ->
      socketIo.emit(
        event,
        data,
        fun(data: ArrayList<JsonElement>?) {
          val resp = data?.first()?.asString()
          cont.resume(resp ?: "")
        }
      )
    }
  }

  fun emitAckAsync(event: String, data: String) {
    socketIo.emit(event, data)
  }

  fun connect() {
    socketIo.connect()
  }

  fun disconnect() {
    socketIo.disconnect()
  }

  fun isConnected(): Boolean {
    return socketIo.connected
  }
}
