package io.dyte.core.media

import io.dyte.webrtc.MediaStream
import io.dyte.webrtc.MediaStreamConstraintsBuilder
import kotlinx.coroutines.flow.MutableSharedFlow

internal interface DyteUserMedia {
  suspend fun getUserMedia(
    streamConstraints: MediaStreamConstraintsBuilder.() -> Unit = {}
  ): MediaStream

  fun getDisplayMedia(): MediaStream

  fun cleanupDisplay()

  companion object : DyteUserMedia by userMedia {
    var ssVideoTrackAvailable: Boolean = false

    val observer = MutableSharedFlow<String>()

    fun notifyScreenShareStopped() {
      observer.tryEmit("screenShareStopped")
    }
  }
}

internal expect val userMedia: DyteUserMedia
