package io.dyte.core.feat

import io.dyte.core.events.EventEmitter
import io.dyte.core.events.PublicAPIEmitter
import io.dyte.core.listeners.DytePluginEventsListener
import io.dyte.core.plugins.PluginsController
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.cancel
import kotlinx.coroutines.runBlocking
import kotlinx.coroutines.withContext

/**
 * Dyte Plugins
 *
 * @constructor Create un-activated Dyte Plugin
 * @property controllerContainer
 */
class DytePlugins
internal constructor(
  internal val pluginsController: PluginsController,
  private val scope: CoroutineScope
) : PublicAPIEmitter<DytePluginEventsListener>() {
  val all: List<DytePlugin>
    get() = runBlocking { withContext(scope.coroutineContext) { pluginsController.allPlugins } }

  val active: List<DytePlugin>
    get() = runBlocking { withContext(scope.coroutineContext) { pluginsController.activePlugins } }

  override val emitterSuperClass: EventEmitter<DytePluginEventsListener>
    get() = pluginsController

  /**
   * Stops the operations running on Plugins scope and clears the listeners to prevent a leak.
   * Should be called when DytePlugins is no longer used and will be destroyed.
   *
   * For e.g. while leaving room
   */
  internal suspend fun clear() {
    withContext(scope.coroutineContext) { pluginsController.onCleared() }
    scope.cancel()
  }
}
