package io.dyte.core.controllers

import io.dyte.core.socket.events.payloadmodel.inbound.WebSocketStageStatus
import socket.room.StageType

typealias DyteStageStatus = StageStatus

enum class StageStatus {
  OFF_STAGE,
  REQUESTED_TO_JOIN_STAGE,
  ACCEPTED_TO_JOIN_STAGE,
  REJECTED_TO_JOIN_STAGE,
  ON_STAGE;

  companion object {
    fun fromMap(stage: String): DyteStageStatus {
      return when (stage) {
        "offStage" -> OFF_STAGE
        "requestedToJoinStage" -> REQUESTED_TO_JOIN_STAGE
        "acceptedToJoinStage" -> ACCEPTED_TO_JOIN_STAGE
        "rejectedToJoinStage" -> REJECTED_TO_JOIN_STAGE
        "onStage" -> ON_STAGE
        else -> OFF_STAGE
      }
    }

    fun fromStageType(stageType: StageType?): DyteStageStatus {
      stageType?.let {
        when (stageType) {
          StageType.STAGE_TYPE_UNSPECIFIED -> {
            return OFF_STAGE
          }
          StageType.STAGE_TYPE_ON_STAGE -> {
            return ON_STAGE
          }
          StageType.STAGE_TYPE_APPROVED_STAGE -> {
            return ACCEPTED_TO_JOIN_STAGE
          }
          StageType.STAGE_TYPE_REQUESTED_STAGE -> {
            return REQUESTED_TO_JOIN_STAGE
          }
          StageType.STAGE_TYPE_OFF_STAGE -> {
            return OFF_STAGE
          }
        }
      }
        ?: run {
          return DyteStageStatus.OFF_STAGE
        }
    }

    fun fromWebsocketStageStatus(webSocketStageStatus: WebSocketStageStatus?): DyteStageStatus {
      return when (webSocketStageStatus) {
        WebSocketStageStatus.REQUESTED_TO_JOIN_STAGE -> {
          REQUESTED_TO_JOIN_STAGE
        }
        WebSocketStageStatus.ACCEPTED_TO_JOIN_STAGE -> {
          ACCEPTED_TO_JOIN_STAGE
        }
        WebSocketStageStatus.ON_STAGE -> {
          ON_STAGE
        }
        else -> {
          DyteStageStatus.OFF_STAGE
        }
      }
    }
  }

  override fun toString(): String {
    val strString =
      when (this) {
        OFF_STAGE -> "offStage"
        REQUESTED_TO_JOIN_STAGE -> "requestedToJoinStage"
        ACCEPTED_TO_JOIN_STAGE -> "acceptedToJoinStage"
        REJECTED_TO_JOIN_STAGE -> "rejectedToJoinStage"
        ON_STAGE -> "onStage"
      }

    return strString
  }
}
