package io.dyte.core.controllers

import io.dyte.core.platform.IDytePlatformUtilsProvider
import io.webrtc.NetworkMonitor

internal actual class PlatformConnectionChangeListener {

  private val networkMonitor = NetworkMonitor.getInstance()

  actual constructor(provider: IDytePlatformUtilsProvider, disconnectCallback: () -> Unit) {
    try {
      networkMonitor.addObserver { newState ->
        if (newState?.name === "CONNECTION_NONE") {
          disconnectCallback()
        }
      }
    } catch (e: Exception) {}
  }
}
