package io.dyte.core.utils

import kotlinx.serialization.encodeToString
import kotlinx.serialization.json.Json
import kotlinx.serialization.json.JsonElement
import okio.ByteString
import okio.ByteString.Companion.encodeUtf8

internal object JsonUtils {
  fun Json.encodeToByteString(jsonElement: JsonElement): ByteString {
    return encodeToString(jsonElement).encodeUtf8()
  }

  fun Json.decodeFromByteString(byteString: ByteString): JsonElement {
    return parseToJsonElement(byteString.utf8())
  }
}
