package io.dyte.core.listeners

import io.dyte.core.controllers.DyteLivestreamData
import io.dyte.core.feat.DytePlugin
import io.dyte.core.models.DyteJoinedMeetingParticipant
import io.dyte.core.network.info.SelfPermissions

interface DyteDataUpdateListener {
  fun onMetaUpdate(
    roomName: String,
    meetingTitle: String,
    meetingStartedTimestamp: String,
    roomType: String
  ) {}

  fun onSelfPermissionsUpdate(permission: SelfPermissions) {}

  fun onScreenShareUpdate(screenShares: List<DyteJoinedMeetingParticipant>) {}

  fun onPluginsUpdates(plugins: List<DytePlugin>) {}

  fun onLivestreamUpdate(liveStream: DyteLivestreamData) {}
}
