package io.dyte.core.waitingroom

internal abstract class WaitlistSubscription {
  protected var subscriber: WaitlistSubscriber? = null

  open fun subscribe(subscriber: WaitlistSubscriber): Boolean {
    return if (this.subscriber == null) {
      this.subscriber = subscriber
      true
    } else {
      false
    }
  }

  open fun unsubscribe(subscriber: WaitlistSubscriber): Boolean {
    return if (this.subscriber == subscriber) {
      this.subscriber = null
      true
    } else {
      false
    }
  }

  interface WaitlistSubscriber {
    fun onWaitingRequestAccepted()

    fun onWaitingRequestRejected()
  }
}
