package io.dyte.core.plugins.socketservice

import io.dyte.core.socket.socketservice.SocketServiceUtils

internal enum class PluginsSocketEvent(slug: Int) {
  GET_PLUGINS(0),
  ADD_PLUGIN(1),
  ENABLE_PLUGIN_FOR_ROOM(2),
  DISABLE_PLUGIN_FOR_PEERS(3),
  ENABLE_PLUGIN_FOR_PEERS(4),
  DISABLE_PLUGIN_FOR_ROOM(5),
  REMOVE_PLUGIN(6),
  CUSTOM_PLUGIN_EVENT_TO_ROOM(7),
  CUSTOM_PLUGIN_EVENT_TO_PEERS(8),
  STORE_INSERT_KEYS(9),
  STORE_GET_KEYS(10),
  STORE_DELETE_KEYS(11),
  STORE_DELETE(12);

  private val base: Int = 2
  val id: Int = SocketServiceUtils.generateSocketEventId(base, slug)
}
