package io.dyte.core.plugins

import io.dyte.core.Result
import io.dyte.core.network.IApiClient
import io.dyte.core.observability.DyteLogger
import io.ktor.http.URLBuilder
import io.ktor.http.set

internal class PluginModel(
  private val id: String,
  private val baseUrl: String,
  private val dyteBaseUrl: String,
  private val pluginsApi: IApiClient
) {
  private val logger: DyteLogger = DyteLogger

  var enabledBy: String? = null
    private set

  var authToken: String? = null
    private set

  var urlToLoad: String? = null
    private set

  var active: Boolean = false
    private set

  /** Activates plugin locally for self. */
  suspend fun enableLocal(enabledBy: String): Result<Unit, Exception> {
    val active = this.active // mutex.withLock { this.active }

    if (active) {
      logger.info("PluginModel::enableLocal::success already active")
      return Result.Success(Unit) // Expected: Result.Failure(Exception("Plugin already active"))
    }

    try {
      val pluginAuthToken = pluginsApi.authorizePlugin(id).data.token
      val pluginUrl = URLBuilder(baseUrl)
      pluginUrl.set {
        parameters["auth"] = pluginAuthToken
        parameters["pluginId"] = id
        parameters["backend"] = dyteBaseUrl
        encodedParameters["parent"] = "*"
      }

      if (!this.active) {
        authToken = pluginAuthToken
        urlToLoad = pluginUrl.buildString()
        this.enabledBy = enabledBy
        this.active = true
      }
      logger.info("PluginModel::enableLocal::success")
      return Result.Success(Unit)
    } catch (e: Exception) {
      logger.error("PluginModel::enableLocal::failure", e)
      return Result.Failure(e)
    }
  }

  /** Deactivates plugin locally for self. */
  fun disableLocal(): Result<Unit, Exception> {
    if (active) {
      enabledBy = null
      authToken = null
      urlToLoad = null
      active = false
    }
    logger.info("PluginModel::disableLocal::success")
    return Result.Success(Unit)
  }
}
