package io.dyte.core.network.info.mapper

import io.dyte.core.models.DyteMediaPermission
import io.dyte.core.network.info.MiscellaneousPermissions
import io.dyte.core.network.info.RecorderType
import io.dyte.core.network.models.UserPresetPermissionsModel

internal class V1PresetMapper(private val v1PresetPermissions: UserPresetPermissionsModel) {
  fun getMiscellaneousPermissions(): MiscellaneousPermissions {
    val stageEnabled =
      v1PresetPermissions.viewType == "WEBINAR" || v1PresetPermissions.viewType == "LIVESTREAM"

    val videoPermission = getVideoPermission(v1PresetPermissions)
    val audioPermission = getAudioPermission(v1PresetPermissions)
    val screenSharePermission = getScreenSharePermission(v1PresetPermissions)

    val stageAccess =
      if (
        videoPermission == DyteMediaPermission.ALLOWED ||
          audioPermission == DyteMediaPermission.ALLOWED ||
          screenSharePermission === DyteMediaPermission.ALLOWED
      ) {
        DyteMediaPermission.ALLOWED
      } else if (
        videoPermission == DyteMediaPermission.CAN_REQUEST ||
          audioPermission == DyteMediaPermission.CAN_REQUEST ||
          screenSharePermission === DyteMediaPermission.CAN_REQUEST
      ) {
        DyteMediaPermission.CAN_REQUEST
      } else {
        DyteMediaPermission.NOT_ALLOWED
      }

    return MiscellaneousPermissions(
      v1PresetPermissions.canEditDisplayName ?: false,
      v1PresetPermissions.hiddenParticipant ?: false,
      v1PresetPermissions.isRecorder ?: false,
      recorderType = RecorderType.NONE,
      canSpotLight = v1PresetPermissions.canSpotLight ?: false,
      stageEnabled = stageEnabled,
      stageAccess = stageAccess
    )
  }

  private fun getVideoPermission(
    presetPermissions: UserPresetPermissionsModel
  ): DyteMediaPermission {
    return if (presetPermissions.requestProduce == true) {
      DyteMediaPermission.CAN_REQUEST
    } else if (presetPermissions.produce?.video?.allow == true) {
      DyteMediaPermission.ALLOWED
    } else {
      DyteMediaPermission.NOT_ALLOWED
    }
  }

  private fun getAudioPermission(
    presetPermissions: UserPresetPermissionsModel
  ): DyteMediaPermission {
    return if (presetPermissions.requestProduce == true) {
      DyteMediaPermission.CAN_REQUEST
    } else if (presetPermissions.produce?.audio == true) {
      DyteMediaPermission.ALLOWED
    } else {
      DyteMediaPermission.NOT_ALLOWED
    }
  }

  private fun getScreenSharePermission(
    presetPermissions: UserPresetPermissionsModel
  ): DyteMediaPermission {
    return if (presetPermissions.requestProduce == true) {
      DyteMediaPermission.CAN_REQUEST
    } else if (presetPermissions.produce?.screenshare?.allow == true) {
      DyteMediaPermission.ALLOWED
    } else {
      DyteMediaPermission.NOT_ALLOWED
    }
  }
}
