package io.dyte.core.feat

import io.dyte.core.controllers.MetaController
import io.dyte.core.models.ActiveTabType
import io.dyte.core.models.DyteMeetingType

class DyteMeta internal constructor(private val metaController: MetaController) {

  val roomName: String
    get() = metaController.getRoomName()

  val meetingTitle: String
    get() = metaController.getMeetingTitle()

  val meetingStartedTimestamp: String
    get() = metaController.getMeetingStatedTimestamp()

  val meetingStartedTimeInEpox: Long
    get() = metaController.getMeetingStatedTime()

  val meetingType: DyteMeetingType
    get() = metaController.getMeetingType()

  fun toMap(): Map<String, Any?> {
    val map = HashMap<String, Any?>()
    map["roomName"] = roomName
    map["meetingTitle"] = meetingTitle
    map["meetingStartedTimestamp"] = meetingStartedTimestamp
    map["meetingType"] = meetingType.name
    return map
  }

  /* id is the identifier for recognising unique plugin/screen share*/
  fun syncTab(id: String, tabType: ActiveTabType) {
    metaController.syncTab(id, tabType)
  }
}
