package io.dyte.core

enum class SocketErrorCode(val code: Int) {
  Get_Socket_Response_Timeout(12),
  Get_Socket_Response_Is_Null(13)
}

enum class HostControlErrorCodes(val code: Int, val description: String) {
  Unpin_Peer(12, description = "Failed to unpin peer"),
  Pin_Peer(13, description = "Failed to pin peer"),
  Mute_Video(14, description = "Failed to mute video"),
  Mute_Audio(15, description = "Failed to mute audio"),
  Mute_All_Video(16, description = "Failed to mute all video"),
  Mute_All_Audio(17, description = "Failed to mute all audio"),
  Kick_All(18, description = "Failed to kill all"),
  Kick_Peer(19, description = "Failed to kick peer")
}

enum class PresetEditorErrorCodes(val code: Int, val description: String) {
  Record_Permission_Not_Given(12, description = "Record permission is not given on preset editor."),
  Recording_Start_Exception(13, description = "Failed to start recording"),
  Recording_Pause_Exception(14, description = "Failed to pause recording"),
  Recording_Resume_Exception(15, description = "Failed to resume recording"),
  Recording_Stop_Exception(16, description = "Failed to stop recording"),
  No_Active_Recording_Found(17, description = "There is no active recording is in progress")
}

class DyteError(val code: Int, val localisedDescription: String) {
  internal constructor(
    socketErrorCode: SocketErrorCode,
    localisedDescription: String
  ) : this(socketErrorCode.code, localisedDescription)

  internal constructor(
    errorCode: PresetEditorErrorCodes
  ) : this(errorCode.code, errorCode.description)

  internal constructor(
    errorCode: PresetEditorErrorCodes,
    localisedDescription: String
  ) : this(errorCode.code, localisedDescription)

  internal constructor(
    errorCode: HostControlErrorCodes
  ) : this(errorCode.code, errorCode.description)

  internal constructor(
    errorCode: HostControlErrorCodes,
    localisedDescription: String
  ) : this(errorCode.code, localisedDescription)
}

sealed class Result<out SuccessType, out FailureType> {
  data class Success<out R>(val value: R) : Result<R, Nothing>()

  data class Failure<out R>(val value: R) : Result<Nothing, R>()
}
