package io.dyte.core.platform

import android.content.Context
import io.dyte.core.feat.DyteMeetingParticipant
import io.dyte.core.models.DyteJoinedMeetingParticipant
import io.dyte.core.observability.DyteLogger

actual typealias VideoView = io.dyte.core.VideoView

class DyteAndroidVideoUtils
internal constructor(private val utilsProvider: IDytePlatformUtilsProvider) : IDyteVideoUtils {
  private var useCache = true

  private val videoViews = hashMapOf<String, io.dyte.core.VideoView>()
  private val screenShareViews = hashMapOf<String, io.dyte.core.VideoView>()

  override fun getVideoView(participant: DyteJoinedMeetingParticipant): io.dyte.core.VideoView {
    return if (useCache && videoViews.containsKey(participant.id)) {
      val videoView = videoViews.getValue(participant.id)
      // videoView.renderVideo()
      videoView
    } else {
      val videoView =
        io.dyte.core.VideoView(
          utilsProvider
            .getControllerContainer()
            .platformUtilsProvider
            .getPlatformUtils()
            .getActivity() as Context
        )
      videoView.setup(utilsProvider.getControllerContainer(), participant, false)
      videoViews[participant.id] = videoView
      // videoView.renderVideo()
      videoView
    }
  }

  override fun getSelfPreview(): VideoView {
    val participant = utilsProvider.getControllerContainer().selfController.getSelf()
    val videoView =
      io.dyte.core.VideoView(
        utilsProvider
          .getControllerContainer()
          .platformUtilsProvider
          .getPlatformUtils()
          .getActivity() as Context
      )
    videoView.setup(utilsProvider.getControllerContainer(), participant, false)
    val existing = videoViews["self${participant.id}"]
    existing?.release()
    videoViews["self${participant.id}"] = videoView
    return videoView
  }

  override fun getScreenShareView(participant: DyteJoinedMeetingParticipant): VideoView {
    return if (useCache && screenShareViews.containsKey(participant.id) && false) {
      val screenShareView = screenShareViews.getValue(participant.id)
      // screenShareView.renderScreenShare()
      screenShareView
    } else {
      val videoView =
        io.dyte.core.VideoView(
          utilsProvider
            .getControllerContainer()
            .platformUtilsProvider
            .getPlatformUtils()
            .getActivity() as Context
        )
      videoView.setup(utilsProvider.getControllerContainer(), participant, true)
      screenShareViews[participant.id] = videoView
      // videoView.renderScreenShare()
      videoView
    }
  }

  override fun destroyView(participant: DyteMeetingParticipant) {
    videoViews.remove(participant.id)
  }

  override fun destroyScreenShare(participant: DyteMeetingParticipant) {
    screenShareViews.remove(participant.id)
  }

  override fun destroyAll() {
    DyteLogger.info("video_utils::destroyAll")
    videoViews.values.forEach {
      try {
        it.release()
      } catch (e: Exception) {
        e.printStackTrace()
      }
    }
    videoViews.clear()

    screenShareViews.values.forEach {
      try {
        it.release()
      } catch (e: Exception) {
        e.printStackTrace()
      }
    }
    screenShareViews.clear()
  }

  override fun disableCache() {
    DyteLogger.info("video_utils::disableCache")
    useCache = false
    destroyAll()
  }

  override fun enableCache() {
    DyteLogger.info("video_utils::enableCache")
    useCache = true
    destroyAll()
  }
}
