package io.dyte.core.platform

import android.util.Log
import java.io.PrintWriter
import java.io.StringWriter

private const val TAG_PREFIX = "DyteSDK:"

/**
 * Android dyte logger
 *
 * Actual implementation of [IDyteLoggerUtils]
 *
 * @constructor Create empty Android dyte logger
 */
internal class DyteAndroidLogger : IDyteLoggerUtils {

  private var isLogEnabled: Boolean = false

  override fun enableLogger(enable: Boolean) {
    isLogEnabled = enable
  }

  override fun isLoggerEnabled(): Boolean {
    return isLogEnabled
  }

  override fun logI(tag: Any, message: String) {
    if (isLogEnabled) {
      Log.i(getTag(tag), message)
    }
  }

  override fun logD(tag: Any, message: String) {
    if (isLogEnabled) {
      Log.d(getTag(tag), message)
    }
  }

  override fun logW(tag: Any, message: String) {
    if (isLogEnabled) {
      Log.w(getTag(tag), message)
    }
  }

  override fun logE(tag: Any, message: String) {
    if (isLogEnabled) {
      Log.e(getTag(tag), message)
    }
  }

  override fun logE(tag: Any, throwable: Throwable) {
    if (isLogEnabled) {
      Log.e(getTag(tag), getStackString(throwable))
    }
  }

  override fun logE(tag: Any, message: String, throwable: Throwable) {
    if (isLogEnabled) {
      Log.e(getTag(tag), message, throwable)
    }
  }

  private fun getTag(tag: Any?): String {
    val stringTag: String =
      when (tag) {
        null -> "null"
        is String -> tag
        else -> tag.javaClass.simpleName
      }
    return TAG_PREFIX + stringTag
  }

  private fun getStackString(t: Throwable): String {
    val errors = StringWriter()
    t.printStackTrace(PrintWriter(errors))
    return errors.toString()
  }
}
