package io.dyte.core.plugins

import io.dyte.core.Result

internal interface PluginHostMeeting {
  suspend fun activatePlugin(pluginId: String, staggered: Boolean): Result<Unit, Exception>

  suspend fun deactivatePlugin(pluginId: String): Result<Unit, Exception>

  /*
   * TODO: In PluginsController add a check to see if the plugin is currently in active before
   *  processing message.
   * */
  suspend fun onPluginMessage(pluginId: String, pluginMessage: PluginMessage)
}
