@file:Suppress("DEPRECATION") // DyteScreenShareMeetingParticipant

package io.dyte.core.listeners

import io.dyte.core.feat.DyteMeetingParticipant
import io.dyte.core.models.DyteJoinedMeetingParticipant
import io.dyte.core.models.DyteParticipant
import io.dyte.core.models.DyteParticipants

/**
 * Dyte participant events listener
 *
 * You can subscribe to all participant events by implementing this interface. To subscribe pass
 * implementation to [io.dyte.core.DyteMobileClient.addParticipantEventsListener]
 *
 * @constructor Create empty Dyte participant events listener
 */
interface DyteParticipantEventsListener : ExternalEventListener {
  /**
   * On participant join
   *
   * Triggered when a new user joins this room
   *
   * @param participant
   */
  fun onParticipantJoin(participant: DyteJoinedMeetingParticipant) {}

  /**
   * On participant leave
   *
   * Triggered when a user leaves/kicked from this room
   *
   * @param participant
   */
  fun onParticipantLeave(participant: DyteJoinedMeetingParticipant) {}

  /**
   * On screen share started and ended
   *
   * Triggered when someone starts or end screen share in this room
   */
  fun onScreenSharesUpdated() {}

  fun onScreenShareStarted(participant: DyteJoinedMeetingParticipant) {}

  fun onScreenShareEnded(participant: DyteJoinedMeetingParticipant) {}

  /**
   * Audio update
   *
   * when a give participant toggles audio from their device. Also triggered when host toggles audio
   * for the participant
   *
   * @param audioEnabled : true if audio is enabled, false otherwise
   * @param participant : participant for whom there was audio change
   */
  fun onAudioUpdate(audioEnabled: Boolean, participant: DyteMeetingParticipant) {}

  /**
   * Video update
   *
   * when a give participant toggles video from their device. Also triggered when host toggles video
   * for the participant
   *
   * @param videoEnabled : true if video is enabled, false otherwise
   * @param participant : participant for whom there was video change
   */
  fun onVideoUpdate(videoEnabled: Boolean, participant: DyteMeetingParticipant) {}

  /**
   * On participants updated
   *
   * Triggered when there are updates in the meeting room participants
   * 1. new user joins
   * 2. new user in waiting room
   * 3. new user is pinned/unpinned
   * 4. User leaves meeting
   * 5. Page updates
   */
  fun onActiveSpeakerChanged(participant: DyteJoinedMeetingParticipant) {}

  fun onNoActiveSpeaker() {}

  fun onParticipantPinned(participant: DyteJoinedMeetingParticipant) {}

  fun onParticipantUnpinned(participant: DyteJoinedMeetingParticipant) {}

  // called whenever there is any change in participant
  fun onUpdate(participants: DyteParticipants) {}

  fun onActiveParticipantsChanged(active: List<DyteJoinedMeetingParticipant>) {}

  fun onAllParticipantsUpdated(allParticipants: List<DyteParticipant>) {}
}
