package io.dyte.core.listeners

import io.dyte.core.feat.DyteChatMessage

interface DyteChatEventsListener : ExternalEventListener {
  /**
   * On chat updates
   *
   * Triggered when there is a update in chat messages available in this room.
   *
   * @param messages list of all messages in this room. This also contains messages exchanged before
   *   this peer joined in this room
   */
  fun onChatUpdates(messages: List<DyteChatMessage>) {}

  /**
   * On new chat message
   *
   * Triggered when there is a new chat messages exchanged in this room.
   *
   * @param messages list of all messages in this room. This also contains messages exchanged before
   *   this peer joined in this room
   */
  fun onNewChatMessage(message: DyteChatMessage) {}
}
