package io.dyte.core.plugins.factory

import io.dyte.core.feat.DytePlugin
import io.dyte.core.network.IApiClient
import io.dyte.core.platform.IDytePlatformUtilsProvider
import io.dyte.core.plugins.PluginModel
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.DelicateCoroutinesApi
import kotlinx.coroutines.ExperimentalCoroutinesApi
import kotlinx.coroutines.newSingleThreadContext

/**
 * Factory to create [DytePlugin] instance. It injects the [PluginModel] into DytePlugin depending
 * on the [PluginModelFactory] provided.
 */
internal class DytePluginFactory(
  private val pluginsApi: IApiClient,
  private val dyteBaseUrl: String,
  private val webViewProvider: IDytePlatformUtilsProvider
) {
  @OptIn(ExperimentalCoroutinesApi::class, DelicateCoroutinesApi::class)
  fun create(
    id: String,
    name: String,
    description: String,
    picture: String,
    isPrivate: Boolean,
    staggered: Boolean,
    baseURL: String
  ): DytePlugin {
    val pluginModel = PluginModel(id, baseURL, dyteBaseUrl, pluginsApi)

    val scope = CoroutineScope(newSingleThreadContext("DytePluginScope"))
    return DytePlugin(
      id,
      name,
      description,
      picture,
      isPrivate,
      staggered,
      baseURL,
      scope,
      webViewProvider,
      pluginModel
    )
  }
}
