package io.dyte.core.socket.events.payloadmodel.inbound

import io.dyte.core.socket.events.InboundMeetingEventType
import io.dyte.core.socket.events.payloadmodel.BasePayloadModel
import kotlinx.serialization.ExperimentalSerializationApi
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable
import kotlinx.serialization.json.JsonNames

/** response for event [InboundMeetingEventType.WEB_SOCKET_PEER_JOINED] */
@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class WebSocketMeetingPeerUser(
  @SerialName("id") val id: String,
  @SerialName("userId") val userId: String,
  @JsonNames("name", "displayName") val name: String? = null,
  @SerialName("device") val device: Device? = null,
  @SerialName("picture") val picture: String? = null,
  @SerialName("isHost") val isHost: Boolean? = null,
  @SerialName("webinarHiddenParticipant") val webinarHiddenParticipant: Boolean = false,
  @SerialName("flags") val flags: MeetingPeerFlags = MeetingPeerFlags(),
  @SerialName("clientSpecificId") val clientSpecificId: String? = null,
  @SerialName("audioMuted") val audioMuted: Boolean = false,
  @SerialName("hiddenParticipant") val hiddenParticipant: Boolean = false,
  @SerialName("metadata") val participantMetadata: MeetingPeerMetadata = MeetingPeerMetadata(),
  val stageStatus: WebSocketStageStatus = WebSocketStageStatus.OFF_STAGE,
  val requestToJoinType: WebSocketRequestToJoinType? = null,
  @SerialName("preset") val presetType: String? = null,
  val recorderType: WebSocketRecorderType = WebSocketRecorderType.NONE
) : BasePayloadModel()

@Serializable
data class Device(
  @SerialName("isMobile") var isMobile: Boolean = false,
  @SerialName("sdkName") var sdkName: String? = null,
  @SerialName("browserName") var browserName: String? = null,
  @SerialName("osName") var osName: String? = null,
  @SerialName("browserVersion") var browserVersion: String? = null,
  @SerialName("osVersionName") var osVersionName: String? = null,
  @SerialName("engineName") var engineName: String? = null,
)

@Serializable
data class MeetingPeerFlags(
  @SerialName("hiddenParticipant") val hiddenParticipant: Boolean = false,
  @SerialName("recorder") val recorder: Boolean = false,
  @SerialName("webinarHiddenParticipant") val webinarHiddenParticipant: Boolean = false
)

@Serializable
data class MeetingPeerMetadata(
  @SerialName("view_type") val viewType: String? = null,
  @SerialName("preset_name") val presetName: String? = null
)

@Serializable
enum class WebSocketStageStatus {
  OFF_STAGE,
  REQUESTED_TO_JOIN_STAGE,
  ACCEPTED_TO_JOIN_STAGE,
  ON_STAGE,
}

@Serializable
enum class WebSocketRequestToJoinType {
  REQUEST_TO_PRESENT,
  REQUEST_TO_ASK
}

@Serializable
enum class WebSocketRecorderType {
  NONE,
  RECORDER,
  LIVESTREAMER
}
