package io.dyte.core.feat

import io.dyte.core.controllers.DyteStageStatus
import io.dyte.core.controllers.stage.BaseStageController
import io.dyte.core.events.EventEmitter
import io.dyte.core.events.PublicAPIEmitter
import io.dyte.core.listeners.DyteStageEventListener
import io.dyte.core.models.DyteJoinedMeetingParticipant
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.launch
import kotlinx.coroutines.newSingleThreadContext

class DyteStage internal constructor(private val stageController: BaseStageController) :
  PublicAPIEmitter<DyteStageEventListener>() {
  private val serialScope = CoroutineScope(newSingleThreadContext("DyteStage"))

  override val emitterSuperClass: EventEmitter<DyteStageEventListener>
    get() = stageController

  val accessRequests: List<DyteJoinedMeetingParticipant>
    get() = stageController.accessRequests

  val stageStatus: DyteStageStatus
    get() = stageController.stageStatus

  val viewers: List<DyteJoinedMeetingParticipant>
    get() = stageController.viewers

  fun requestAccess() {
    serialScope.launch { stageController.requestAccess() }
  }

  fun cancelRequestAccess() {
    serialScope.launch { stageController.cancelRequestAccess() }
  }

  fun join() {
    serialScope.launch { stageController.join() }
  }

  fun leave() {
    serialScope.launch { stageController.leave() }
  }

  fun kick(id: String) {
    serialScope.launch { stageController.kick(id) }
  }

  fun grantAccess(id: String) {
    serialScope.launch { stageController.grantAccess(id) }
  }

  fun grantAccessAll() {
    serialScope.launch { stageController.grantAccessAll() }
  }

  fun denyAccess(id: String) {
    serialScope.launch { stageController.denyAccess(id) }
  }

  fun denyAccessAll() {
    serialScope.launch { stageController.denyAccessAll() }
  }
}
