package io.dyte.core.controllers.stage

import io.dyte.core.controllers.DyteStageStatus
import io.dyte.core.events.EventEmitter
import io.dyte.core.events.InternalEvents
import io.dyte.core.listeners.DyteStageEventListener
import io.dyte.core.models.DyteJoinedMeetingParticipant
import io.dyte.core.models.DyteSelfParticipant

abstract class BaseStageController(private val self: DyteSelfParticipant) :
  EventEmitter<DyteStageEventListener>(), IStageController, InternalEvents {
  internal val _accessRequests = arrayListOf<DyteJoinedMeetingParticipant>()
  override val accessRequests: List<DyteJoinedMeetingParticipant>
    get() = _accessRequests

  abstract val viewers: List<DyteJoinedMeetingParticipant>

  val stageStatus: DyteStageStatus
    get() = self._stageStatus

  fun init() {
    setupEvents()
  }
}

internal interface IStageController {

  fun setupEvents()

  /** list of requests which are asking to join stage */
  val accessRequests: List<DyteJoinedMeetingParticipant>

  /**
   * for participants who have audio == need_to_request OR video == need_to_request, first should
   * ask host permission to join stage.
   */
  suspend fun requestAccess()

  /** to cancel request to access stage */
  suspend fun cancelRequestAccess()

  /**
   * to join stage. for participants with audio and video permission set to need_to_request first
   * should get there request approved and then call join.
   */
  suspend fun join()

  /** to leave stage. */
  suspend fun leave()

  /** to kick a give peerId from stage */
  suspend fun kick(id: String)

  /** to accept a access request from a participant */
  suspend fun grantAccess(id: String)
  /** to accept all access requests */
  suspend fun grantAccessAll()

  /** to reject a access request from a participant */
  suspend fun denyAccess(id: String)
  /** to reject all access requests */
  suspend fun denyAccessAll()
}
